<?php
require_once('source/session.php');
require_once('source/error.php');
require_once('source/dbconfig.php');
require_once('source/function.php');
require_once('source/restrict_admin.php');

// Check if student ID is provided
if (!isset($_GET['id'])) {
    header("Location: students.php");
    exit();
}

$student_id = intval($_GET['id']);

// Fetch student data
$student = sql($DBH, "SELECT * FROM tbl_user WHERE id = ? AND teacher = ?", [$student_id, "false"], "rows");
if (empty($student)) {
    header("Location: students.php");
    exit();
}
$student = $student[0];

// Handle form submission
$error = '';
$success = '';
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $fullname = strip_tags($_POST['fullname']);
    $email = strip_tags($_POST['email']);
    $gender = strip_tags($_POST['gender']);
    $phone = strip_tags($_POST['phone']);
    $class = strip_tags($_POST['class']);
    $subclass = strip_tags($_POST['subclass']);
    $age = strip_tags($_POST['age']); // Date of birth
    
    // Handle photo upload
    $photo_name = $student['profile_pic'];
    if (isset($_FILES['photo']) && $_FILES['photo']['error'] == UPLOAD_ERR_OK) {
        $upload_dir = '../coll_admin/profile_pic/';
        $photo_name = uniqid() . '_' . basename($_FILES['photo']['name']);
        $target_file = $upload_dir . $photo_name;
        
        // Check if image file is actual image
        $check = getimagesize($_FILES['photo']['tmp_name']);
        if ($check !== false) {
            if (move_uploaded_file($_FILES['photo']['tmp_name'], $target_file)) {
                // Delete old photo if it exists and is not default
                if ($student['profile_pic'] && !str_contains($student['profile_pic'], 'default')) {
                    @unlink($upload_dir . $student['profile_pic']);
                }
            } else {
                $error = "Sorry, there was an error uploading your file.";
                $photo_name = $student['profile_pic'];
            }
        } else {
            $error = "File is not an image.";
            $photo_name = $student['profile_pic'];
        }
    }

    try {
        $result = sql($DBH, 
            "UPDATE tbl_user SET fullname = ?, email = ?, registration_no = ?, gender = ?, phone = ?, class = ?, subclass = ?, age = ?, profile_pic = ? WHERE id = ?", 
            [$fullname, $email, $email, $gender, $phone, $class, $subclass, $age, $photo_name, $student_id], 
            "count"
        );
        
        if ($result > 0) {
            $success = "Student updated successfully";
            // Refresh student data
            $student = sql($DBH, "SELECT * FROM tbl_user WHERE id = ?", [$student_id], "rows")[0];
        } else {
            $error = "No changes were made";
        }
    } catch (Exception $e) {
        $error = "Error updating student: " . $e->getMessage();
    }
}

// Get admin full name
$admin_fullname = '';
$rows = sql($DBH, "SELECT fullname FROM tbl_admin WHERE status = ?", ["Active"], "rows");
if(!empty($rows)) {
    $admin_fullname = $rows[0]['fullname'];
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <title>Edit Student - VERBUM DEI INT'L COLLEGE</title>
  <link rel="icon" type="image/png" href="https://portal.vda.com.ng/coll_admin/coll_logo.jpg">
  
  <!-- Bootstrap 5 CSS -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  
  <!-- Font Awesome -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  
  <!-- Google Fonts -->
  <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
  
  <!-- Custom CSS -->
  <style>
    :root {
      --primary-blue: #1976d2;
      --dark-blue: #0d47a1;
      --light-blue: #64b5f6;
      --accent-blue: #bbdefb;
      --bg-light: #e3f2fd;
      --text-dark: #212529;
    }
    
    body {
      font-family: 'Poppins', sans-serif;
      background-color: var(--bg-light);
      min-height: 100vh;
      display: flex;
      flex-direction: column;
    }
    
    /* Navbar Styles */
    .navbar {
      background-color: var(--primary-blue);
      box-shadow: 0 0.15rem 1.75rem 0 rgba(33, 37, 41, 0.1);
      position: fixed;
      top: 0;
      width: 100%;
      z-index: 1030;
      color: white;
    }
    
    .navbar-brand {
      font-weight: 800;
      font-size: 1.2rem;
      color: white;
    }
    
    /* Sidebar Styles */
    .sidebar {
      background: linear-gradient(180deg, var(--dark-blue) 0%, var(--primary-blue) 100%);
      position: fixed;
      top: 56px;
      left: -250px;
      width: 250px;
      height: calc(100vh - 56px);
      transition: all 0.3s;
      z-index: 1000;
      overflow-y: auto;
    }
    
    .sidebar.active {
      left: 0;
    }
    
    .sidebar .nav-link {
      color: rgba(255, 255, 255, 0.85);
      font-weight: 600;
      padding: 0.75rem 1rem;
      margin-bottom: 0.2rem;
      transition: all 0.2s;
    }
    
    .sidebar .nav-link:hover {
      color: #fff;
      background-color: rgba(255, 255, 255, 0.15);
    }
    
    .sidebar .nav-link.active {
      color: #fff;
      background-color: var(--light-blue);
      box-shadow: 0 2px 5px rgba(0,0,0,0.1);
    }
    
    .sidebar .nav-link i {
      margin-right: 0.5rem;
      width: 20px;
      text-align: center;
    }
    
    /* Main Content Styles */
    .main-content {
      margin-left: 0;
      width: 100%;
      transition: all 0.3s;
      flex: 1 0 auto;
      padding-top: 56px;
    }
    
    @media (min-width: 992px) {
      .sidebar {
        left: 0;
      }
      .main-content {
        margin-left: 250px;
        width: calc(100% - 250px);
      }
    }
    
    /* Card Styles */
    .card {
      border: none;
      border-radius: 12px;
      box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.1);
      margin-bottom: 1.5rem;
      transition: transform 0.3s, box-shadow 0.3s;
    }
    
    .card:hover {
      transform: translateY(-5px);
      box-shadow: 0 1rem 2rem rgba(0, 0, 0, 0.15);
    }
    
    .card-header {
      background-color: var(--accent-blue);
      border-bottom: 1px solid var(--light-blue);
      font-weight: 700;
      color: var(--dark-blue);
      padding: 1rem 1.5rem;
    }
    
    /* Button Styles */
    .btn-primary {
      background-color: var(--primary-blue);
      border-color: var(--primary-blue);
      padding: 0.5rem 1.5rem;
      font-weight: 600;
    }
    
    .btn-primary:hover {
      background-color: var(--dark-blue);
      border-color: var(--dark-blue);
    }
    
    /* Form Styles */
    .form-control, .form-select {
      height: 50px;
      border-radius: 8px;
      padding: 0.5rem 1rem;
      border: 1px solid #ced4da;
      transition: all 0.3s;
    }
    
    .form-control:focus, .form-select:focus {
      border-color: var(--light-blue);
      box-shadow: 0 0 0 0.25rem rgba(100, 181, 246, 0.25);
    }
    
    /* Student Photo */
    .student-photo {
      width: 150px;
      height: 150px;
      object-fit: cover;
      border-radius: 50%;
      border: 3px solid var(--accent-blue);
      margin: 0 auto 1rem;
      display: block;
    }
    
    .photo-upload-btn {
      position: relative;
      overflow: hidden;
      display: inline-block;
    }
    
    .photo-upload-btn input[type="file"] {
      position: absolute;
      left: 0;
      top: 0;
      opacity: 0;
      width: 100%;
      height: 100%;
      cursor: pointer;
    }
    
    /* Admin Info Styles */
    .admin-info {
      display: flex;
      align-items: center;
      background-color: rgba(255,255,255,0.2);
      padding: 8px 12px;
      border-radius: 8px;
      color: white;
    }
    
    .admin-name {
      margin-right: 5px;
      font-weight: 600;
    }
    
    .admin-access {
      font-style: italic;
      opacity: 0.8;
      margin-right: 10px;
      font-size: 0.9rem;
    }
    
    .admin-icon {
      font-size: 1.5rem;
      color: white;
    }
    
    /* Footer styles */
    .footer {
      background-color: var(--dark-blue);
      color: white;
      padding: 20px 0;
      flex-shrink: 0;
      width: 100%;
    }
    
    @media (min-width: 992px) {
      .footer {
        margin-left: 250px;
        width: calc(100% - 250px);
      }
    }
    
    .copyright-text {
      font-weight: 600;
      font-size: 1rem;
    }
    
    /* Support badge */
    .support-badge {
      background-color: var(--accent-blue);
      color: var(--dark-blue);
      font-weight: 600;
      padding: 0.5rem 1rem;
    }
    
    /* Breadcrumbs */
    .breadcrumb-custom .breadcrumb {
      background-color: transparent;
      padding: 0;
    }
    
    .breadcrumb-custom .breadcrumb-item a {
      color: var(--primary-blue);
      text-decoration: none;
    }
    
    .breadcrumb-custom .breadcrumb-item.active {
      color: var(--dark-blue);
      font-weight: 500;
    }
    
    /* Responsive adjustments */
    @media (max-width: 768px) {
      .card-body {
        padding: 1.5rem;
      }
      
      .admin-info {
        padding: 6px 10px;
      }
      
      .admin-name, .admin-access {
        font-size: 0.8rem;
      }
      
      .student-photo {
        width: 120px;
        height: 120px;
      }
    }
  </style>
</head>

<body>
  <!-- Top Navigation -->
  <nav class="navbar navbar-expand-lg navbar-dark">
    <div class="container-fluid">
      <button id="sidebarToggle" class="btn btn-link d-lg-none me-2">
        <i class="fas fa-bars"></i>
      </button>
      <a class="navbar-brand d-none d-lg-block" href="#">
        VERBUM DEI INT'L COLLEGE
      </a>
      <div class="ms-auto d-flex align-items-center">
        <div class="admin-info me-3">
          <span class="admin-name"><?php echo htmlspecialchars($admin_fullname); ?></span>
          <span class="admin-access">(Administrator)</span>
          <i class="fas fa-user-circle admin-icon"></i>
        </div>
        <a href="logout.php" class="btn btn-sm btn-outline-light">
          <i class="fas fa-sign-out-alt"></i>
        </a>
      </div>
    </div>
  </nav>

  <!-- Sidebar -->
  <nav id="sidebar" class="sidebar">
    <div class="position-sticky pt-3">
      <div class="text-center mb-4 d-none d-lg-block">
        <img src="https://portal.vda.com.ng/coll_admin/coll_logo.jpg" alt="School Logo" class="rounded-circle" width="80">
        <h5 class="mt-2 text-white">VERBUM DEI INT'L COLLEGE</h5>
        <p class="text-white-50 small">Admin Dashboard</p>
      </div>
      
      <ul class="nav flex-column">
        <li class="nav-item">
          <a class="nav-link" href="main.php">
            <i class="fas fa-fw fa-tachometer-alt"></i>
            Admin Centre
          </a>
        </li>
        <li class="nav-item">
          <a class="nav-link" href="post_session.php">
            <i class="fas fa-fw fa-calendar-alt"></i>
            School Year/Session
          </a>
        </li>
        <li class="nav-item">
          <a class="nav-link" href="post_classes.php">
            <i class="fas fa-fw fa-building"></i>
            Manage Classes
          </a>
        </li>
        <li class="nav-item">
          <a class="nav-link" href="add_students.php">
            <i class="fas fa-fw fa-user-plus"></i>
            Register New Student
          </a>
        </li>
        <li class="nav-item">
          <a class="nav-link" href="post_subjects.php">
            <i class="fas fa-fw fa-book"></i>
            Create Subjects
          </a>
        </li>
        <li class="nav-item">
          <a class="nav-link" href="teachers.php">
            <i class="fas fa-fw fa-chalkboard-teacher"></i>
            Manage Teachers
          </a>
        </li>
        <li class="nav-item">
          <a class="nav-link" href="students.php">
            <i class="fas fa-fw fa-users"></i>
            Manage Students
          </a>
        </li>
        <li class="nav-item">
          <a class="nav-link active" href="deactivate_students.php">
            <i class="fas fa-fw fa-user-lock"></i>
            Activate/Deactivate
          </a>
        </li>
      </ul>
    </div>
  </nav>

  <!-- Main Content -->
  <main class="main-content">
    <div class="container-fluid px-4 pt-4">
      <!-- Page Heading -->
      <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Edit Student</h1>
        <div class="d-none d-sm-inline-block">
          <span class="badge support-badge p-2">
            <i class="fas fa-phone-alt me-1"></i> Support: 08032929756
          </span>
        </div>
      </div>

      <!-- Error Message -->
      <?php if (!empty($error)): ?>
      <div class="alert alert-danger mb-4">
        <i class="fas fa-exclamation-circle me-2"></i><?php echo htmlspecialchars($error); ?>
      </div>
      <?php endif; ?>
      
      <!-- Success Message -->
      <?php if (!empty($success)): ?>
      <div class="alert alert-success mb-4">
        <i class="fas fa-check-circle me-2"></i><?php echo htmlspecialchars($success); ?>
      </div>
      <?php endif; ?>

      <!-- Breadcrumbs -->
      <div class="breadcrumb-custom mb-4">
        <nav aria-label="breadcrumb">
          <ol class="breadcrumb mb-0">
            <li class="breadcrumb-item"><a href="main.php">Admin Dashboard</a></li>
            <li class="breadcrumb-item"><a href="students.php">Manage Students</a></li>
            <li class="breadcrumb-item active">Edit Student</li>
          </ol>
        </nav>
      </div>

      <!-- Edit Student Form -->
      <div class="card shadow mb-4">
        <div class="card-header py-3">
          <h6 class="m-0 font-weight-bold">Editing: <?php echo htmlspecialchars($student['fullname']); ?></h6>
        </div>
        <div class="card-body">
          <form method="post" enctype="multipart/form-data" class="form-horizontal">
            <div class="row">
              <div class="col-md-4 text-center mb-4">
                <?php if($student['profile_pic']): ?>
                  <img src="../coll_admin/profile_pic/<?php echo htmlspecialchars($student['profile_pic']); ?>" 
                       class="student-photo" id="photoPreview">
                <?php else: ?>
                  <div class="student-photo bg-secondary text-white d-flex align-items-center justify-content-center">
                    <i class="fas fa-user fa-4x"></i>
                  </div>
                <?php endif; ?>
                
                <div class="photo-upload-btn">
                  <button type="button" class="btn btn-primary">
                    <i class="fas fa-camera me-2"></i>Change Photo
                  </button>
                  <input type="file" name="photo" id="photoInput" accept="image/*">
                </div>
                <small class="text-muted">Max size: 2MB (JPEG, PNG)</small>
              </div>
              
              <div class="col-md-8">
                <div class="row mb-3">
                  <div class="col-md-6">
                    <label class="form-label">Full Name <span class="text-danger">*</span></label>
                    <input type="text" name="fullname" class="form-control" 
                           value="<?php echo htmlspecialchars($student['fullname']); ?>" required>
                  </div>
                  <div class="col-md-6">
                    <label class="form-label">Admission Number <span class="text-danger">*</span></label>
                    <input type="text" name="email" class="form-control" 
                           value="<?php echo htmlspecialchars($student['email']); ?>" required>
                  </div>
                </div>
                
                <div class="row mb-3">
                  <div class="col-md-6">
                    <label class="form-label">Gender <span class="text-danger">*</span></label>
                    <select name="gender" class="form-select" required>
                      <option value="MALE" <?php echo ($student['gender'] == 'MALE') ? 'selected' : ''; ?>>MALE</option>
                      <option value="FEMALE" <?php echo ($student['gender'] == 'FEMALE') ? 'selected' : ''; ?>>FEMALE</option>
                    </select>
                  </div>
                  <div class="col-md-6">
                    <label class="form-label">Phone Number</label>
                    <input type="tel" name="phone" class="form-control" 
                           value="<?php echo htmlspecialchars($student['phone']); ?>">
                  </div>
                </div>
                
                <div class="row mb-3">
                  <div class="col-md-6">
                    <label class="form-label">Class <span class="text-danger">*</span></label>
                    <select name="class" class="form-select" required>
                      <option value="">Select Class</option>
                      <?php
                      $rows1 = sql($DBH, "SELECT * FROM tbl_class WHERE id >= ?", [1], "rows");
                      foreach($rows1 as $row1) {
                          $selected = ($row1['class'] == $student['class']) ? 'selected' : '';
                          echo "<option value='{$row1['class']}' $selected>{$row1['class']}</option>";
                      }
                      ?>
                    </select>
                  </div>
                  <div class="col-md-6">
                    <label class="form-label">Sub-Class <span class="text-danger">*</span></label>
                    <select name="subclass" class="form-select" required>
                      <option value="">Select Sub-Class</option>
                      <?php
                      $rows1 = sql($DBH, "SELECT * FROM tbl_class WHERE id >= ?", [1], "rows");
                      foreach($rows1 as $row1) {
                          $selected = ($row1['subclass'] == $student['subclass']) ? 'selected' : '';
                          echo "<option value='{$row1['subclass']}' $selected>{$row1['subclass']}</option>";
                      }
                      ?>
                    </select>
                  </div>
                </div>
                
                <div class="row mb-3">
                  <div class="col-md-6">
                    <label class="form-label">Date of Birth <span class="text-danger">*</span></label>
                    <input type="date" name="age" class="form-control" 
                           value="<?php echo htmlspecialchars($student['age']); ?>" required>
                  </div>
                </div>
                
                <div class="row mt-4">
                  <div class="col-12 text-center">
                    <button type="submit" class="btn btn-primary btn-lg px-5 py-3 me-3">
                      <i class="fas fa-save me-2"></i>Save Changes
                    </button>
                    <a href="students.php" class="btn btn-outline-secondary btn-lg px-5 py-3">
                      <i class="fas fa-times me-2"></i>Cancel
                    </a>
                  </div>
                </div>
              </div>
            </div>
          </form>
        </div>
      </div>
    </div>
  </main>

  <!-- Footer -->
  <footer class="footer">
    <div class="container-fluid">
      <div class="row align-items-center">
        <div class="col-md-6">
          <span class="copyright-text">Copyright &copy; VERBUM DEI INT'L COLLEGE <?php echo date("Y"); ?></span>
        </div>
        <div class="col-md-6">
          <div class="text-md-end">
            <a href="https://dataswift.com.ng" target="_blank" rel="noopener noreferrer" class="text-white">
              <span>Powered by DataSwift</span>
              <img src="datalogo.png" alt="DataSwift Logo" class="ms-2" height="24">
            </a>
          </div>
        </div>
      </div>
    </div>
  </footer>

  <!-- Bootstrap 5 JS Bundle with Popper -->
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
  
  <!-- jQuery -->
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  
  <!-- Custom Scripts -->
  <script>
    // Toggle sidebar on mobile
    $(document).ready(function() {
        $('#sidebarToggle').on('click', function() {
            $('#sidebar, .main-content').toggleClass('active');
        });
        
        // Photo preview functionality
        $('#photoInput').change(function(e) {
            const file = e.target.files[0];
            if (file) {
                const reader = new FileReader();
                reader.onload = function(event) {
                    if ($('#photoPreview').length) {
                        $('#photoPreview').attr('src', event.target.result);
                    } else {
                        $('.student-photo').replaceWith(
                            '<img src="' + event.target.result + '" class="student-photo" id="photoPreview">'
                        );
                    }
                };
                reader.readAsDataURL(file);
            }
        });
        
        // Form validation
        $('form').submit(function() {
            let valid = true;
            $(this).find('[required]').each(function() {
                if (!$(this).val()) {
                    $(this).addClass('is-invalid');
                    valid = false;
                } else {
                    $(this).removeClass('is-invalid');
                }
            });
            
            if (!valid) {
                alert('Please fill all required fields');
                return false;
            }
            return true;
        });
    });
  </script>
</body>
</html>